/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.format;

import icyllis.flexmark.util.format.TrackedOffset;
import icyllis.flexmark.util.format.TrackedOffsetList;
import icyllis.flexmark.util.misc.CharPredicate;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.LineAppendable;
import icyllis.flexmark.util.sequence.LineInfo;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;
import icyllis.flexmark.util.sequence.builder.SequenceBuilder;
import icyllis.flexmark.util.sequence.builder.tree.BasedOffsetTracker;
import icyllis.flexmark.util.sequence.builder.tree.OffsetInfo;
import java.util.List;

public class TrackedOffsetUtils {
    public static void resolveTrackedOffsets(BasedSequence sequence, LineAppendable appendable, List<TrackedOffset> offsets, int maxTrailingBlankLines, boolean traceDetails) {
        if (!offsets.isEmpty()) {
            TrackedOffsetList trackedOffsets = TrackedOffsetList.create(sequence, offsets);
            int unresolved = trackedOffsets.size();
            int length = 0;
            ISequenceBuilder<?, ?> appendableBuilder = appendable.getBuilder();
            BasedSequence baseSeq = appendableBuilder instanceof SequenceBuilder ? ((SequenceBuilder)appendableBuilder).getBaseSequence() : sequence.getBaseSequence();
            for (LineInfo lineInfo : appendable.getLinesInfo(maxTrailingBlankLines, 0, appendable.getLineCount())) {
                BasedSequence line = lineInfo.getLine();
                TrackedOffsetList lineTrackedOffsets = trackedOffsets.getTrackedOffsets(line.getStartOffset(), line.getEndOffset());
                if (!lineTrackedOffsets.isEmpty()) {
                    for (TrackedOffset trackedOffset : lineTrackedOffsets) {
                        OffsetInfo info;
                        BasedOffsetTracker tracker = BasedOffsetTracker.create(line);
                        if (trackedOffset.isResolved()) continue;
                        int offset = trackedOffset.getOffset();
                        boolean baseIsWhiteSpaceAtOffset = baseSeq.isCharAt(offset, CharPredicate.WHITESPACE);
                        if (baseIsWhiteSpaceAtOffset && !baseSeq.isCharAt(offset - 1, CharPredicate.WHITESPACE)) {
                            info = tracker.getOffsetInfo(offset - 1, false);
                            trackedOffset.setIndex(info.endIndex + length);
                        } else if (!baseIsWhiteSpaceAtOffset && baseSeq.isCharAt(offset + 1, CharPredicate.WHITESPACE)) {
                            info = tracker.getOffsetInfo(offset, false);
                            trackedOffset.setIndex(info.startIndex + length);
                        } else {
                            info = tracker.getOffsetInfo(offset, true);
                            trackedOffset.setIndex(info.endIndex + length);
                        }
                        if (traceDetails) {
                            System.out.println(String.format("Resolved %d to %d, start: %d, in line[%d]: '%s'", offset, trackedOffset.getIndex(), length, lineInfo.index, ((SequenceBuilder)line.getBuilder().append(line)).toStringWithRanges(true)));
                        }
                        --unresolved;
                    }
                }
                length += line.length();
                if (unresolved > 0) continue;
                break;
            }
        }
    }
}

